# [YooKassa API SDK](../home.md)

# Interface: PaymentsRequestInterface
### Namespace: [\YooKassa\Request\Payments](../namespaces/yookassa-request-payments.md)
---
**Summary:**

Interface PaymentsRequestInterface.

---
### Constants
* No constants found

---
### Methods
| Visibility | Name | Flag | Summary |
| ----------:| ---- | ---- | ------- |
| public | [getCapturedAtGt()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_getCapturedAtGt) |  | Возвращает дату создания от которой будут возвращены платежи или null, если дата не была установлена. |
| public | [getCapturedAtGte()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_getCapturedAtGte) |  | Возвращает дату создания от которой будут возвращены платежи или null, если дата не была установлена. |
| public | [getCapturedAtLt()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_getCapturedAtLt) |  | Возвращает дату создания до которой будут возвращены платежи или null, если дата не была установлена. |
| public | [getCapturedAtLte()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_getCapturedAtLte) |  | Возвращает дату создания до которой будут возвращены платежи или null, если дата не была установлена. |
| public | [getCreatedAtGt()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_getCreatedAtGt) |  | Возвращает дату создания от которой будут возвращены платежи или null, если дата не была установлена. |
| public | [getCreatedAtGte()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_getCreatedAtGte) |  | Возвращает дату создания от которой будут возвращены платежи или null, если дата не была установлена. |
| public | [getCreatedAtLt()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_getCreatedAtLt) |  | Возвращает дату создания до которой будут возвращены платежи или null, если дата не была установлена. |
| public | [getCreatedAtLte()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_getCreatedAtLte) |  | Возвращает дату создания до которой будут возвращены платежи или null, если дата не была установлена. |
| public | [getCursor()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_getCursor) |  | Возвращает страницу выдачи результатов или null, если она до этого не была установлена. |
| public | [getLimit()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_getLimit) |  | Возвращает ограничение количества объектов платежа или null, если оно до этого не было установлено. |
| public | [getPaymentMethod()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_getPaymentMethod) |  | Возвращает код способа оплаты выбираемых платежей или null, если он до этого не был установлен. |
| public | [getStatus()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_getStatus) |  | Возвращает статус выбираемых платежей или null, если он до этого не был установлен. |
| public | [hasCapturedAtGt()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_hasCapturedAtGt) |  | Проверяет, была ли установлена дата создания от которой выбираются платежи. |
| public | [hasCapturedAtGte()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_hasCapturedAtGte) |  | Проверяет, была ли установлена дата создания от которой выбираются платежи. |
| public | [hasCapturedAtLt()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_hasCapturedAtLt) |  | Проверяет, была ли установлена дата создания до которой выбираются платежи. |
| public | [hasCapturedAtLte()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_hasCapturedAtLte) |  | Проверяет, была ли установлена дата создания до которой выбираются платежи. |
| public | [hasCreatedAtGt()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_hasCreatedAtGt) |  | Проверяет, была ли установлена дата создания от которой выбираются платежи. |
| public | [hasCreatedAtGte()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_hasCreatedAtGte) |  | Проверяет, была ли установлена дата создания от которой выбираются платежи. |
| public | [hasCreatedAtLt()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_hasCreatedAtLt) |  | Проверяет, была ли установлена дата создания до которой выбираются платежи. |
| public | [hasCreatedAtLte()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_hasCreatedAtLte) |  | Проверяет, была ли установлена дата создания до которой выбираются платежи. |
| public | [hasCursor()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_hasCursor) |  | Проверяет, была ли установлена страница выдачи результатов. |
| public | [hasLimit()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_hasLimit) |  | Проверяет, было ли установлено ограничение количества объектов платежа. |
| public | [hasPaymentMethod()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_hasPaymentMethod) |  | Проверяет, был ли установлен код способа оплаты выбираемых платежей. |
| public | [hasStatus()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_hasStatus) |  | Проверяет, был ли установлен статус выбираемых платежей. |
| public | [setCapturedAtGt()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_setCapturedAtGt) |  | Устанавливает дату создания от которой выбираются платежи. |
| public | [setCapturedAtGte()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_setCapturedAtGte) |  | Устанавливает дату создания от которой выбираются платежи. |
| public | [setCapturedAtLt()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_setCapturedAtLt) |  | Устанавливает дату создания до которой выбираются платежи. |
| public | [setCapturedAtLte()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_setCapturedAtLte) |  | Устанавливает дату создания до которой выбираются платежи. |
| public | [setCreatedAtGt()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_setCreatedAtGt) |  | Устанавливает дату создания от которой выбираются платежи. |
| public | [setCreatedAtGte()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_setCreatedAtGte) |  | Устанавливает дату создания от которой выбираются платежи. |
| public | [setCreatedAtLt()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_setCreatedAtLt) |  | Устанавливает дату создания до которой выбираются платежи. |
| public | [setCreatedAtLte()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_setCreatedAtLte) |  | Устанавливает дату создания до которой выбираются платежи. |
| public | [setCursor()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_setCursor) |  | Устанавливает страницу выдачи результатов. |
| public | [setLimit()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_setLimit) |  | Устанавливает ограничение количества объектов платежа. |
| public | [setPaymentMethod()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_setPaymentMethod) |  | Устанавливает код способа оплаты выбираемых платежей. |
| public | [setStatus()](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md#method_setStatus) |  | Устанавливает статус выбираемых платежей. |

---
### Details
* File: [lib/Request/Payments/PaymentsRequestInterface.php](../../lib/Request/Payments/PaymentsRequestInterface.php)
* Package: \YooKassa\Request
* See Also:
  * [](https://yookassa.ru/developers/api)

---
### Tags
| Tag | Version | Description |
| --- | ------- | ----------- |
| category |  | Class |
| author |  | cms@yoomoney.ru |
| property |  | Страница выдачи результатов, которую необходимо отобразить |
| property |  | Время создания, от (включительно) |
| property |  | Время создания, от (не включая) |
| property |  | Время создания, до (включительно) |
| property |  | Время создания, до (не включая) |
| property |  | Время подтверждения, от (включительно) |
| property |  | Время подтверждения, от (не включая) |
| property |  | Время подтверждения, до (включительно) |
| property |  | Время подтверждения, до (не включая) |
| property |  | Ограничение количества объектов платежа, отображаемых на одной странице выдачи |
| property |  | Идентификатор шлюза. |
| property |  | Статус платежа |

---
## Methods
<a name="method_getCursor" class="anchor"></a>
#### public getCursor() : null|string

```php
public getCursor() : null|string
```

**Summary**

Возвращает страницу выдачи результатов или null, если она до этого не была установлена.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** null|string - Страница выдачи результатов


<a name="method_hasCursor" class="anchor"></a>
#### public hasCursor() : bool

```php
public hasCursor() : bool
```

**Summary**

Проверяет, была ли установлена страница выдачи результатов.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** bool - True если страница выдачи результатов была установлена, false если нет


<a name="method_setCursor" class="anchor"></a>
#### public setCursor() : self

```php
public setCursor(string $cursor) : self
```

**Summary**

Устанавливает страницу выдачи результатов.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | cursor  | Страница |

**Returns:** self - 


<a name="method_getLimit" class="anchor"></a>
#### public getLimit() : null|int

```php
public getLimit() : null|int
```

**Summary**

Возвращает ограничение количества объектов платежа или null, если оно до этого не было установлено.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** null|int - Ограничение количества объектов платежа


<a name="method_hasLimit" class="anchor"></a>
#### public hasLimit() : bool

```php
public hasLimit() : bool
```

**Summary**

Проверяет, было ли установлено ограничение количества объектов платежа.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** bool - True если ограничение количества объектов платежа было установлено, false если нет


<a name="method_setLimit" class="anchor"></a>
#### public setLimit() : self

```php
public setLimit(int $limit) : self
```

**Summary**

Устанавливает ограничение количества объектов платежа.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">int</code> | limit  | Количества объектов платежа на странице |

**Returns:** self - 


<a name="method_getCreatedAtGte" class="anchor"></a>
#### public getCreatedAtGte() : null|\DateTime

```php
public getCreatedAtGte() : null|\DateTime
```

**Summary**

Возвращает дату создания от которой будут возвращены платежи или null, если дата не была установлена.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** null|\DateTime - Время создания, от (включительно)


<a name="method_hasCreatedAtGte" class="anchor"></a>
#### public hasCreatedAtGte() : bool

```php
public hasCreatedAtGte() : bool
```

**Summary**

Проверяет, была ли установлена дата создания от которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** bool - True если дата была установлена, false если нет


<a name="method_setCreatedAtGte" class="anchor"></a>
#### public setCreatedAtGte() : self

```php
public setCreatedAtGte(\DateTime|string|null $_created_at_gte) : self
```

**Summary**

Устанавливает дату создания от которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">\DateTime OR string OR null</code> | _created_at_gte  | Дата |

**Returns:** self - 


<a name="method_getCreatedAtGt" class="anchor"></a>
#### public getCreatedAtGt() : null|\DateTime

```php
public getCreatedAtGt() : null|\DateTime
```

**Summary**

Возвращает дату создания от которой будут возвращены платежи или null, если дата не была установлена.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** null|\DateTime - Время создания, от (не включая)


<a name="method_hasCreatedAtGt" class="anchor"></a>
#### public hasCreatedAtGt() : bool

```php
public hasCreatedAtGt() : bool
```

**Summary**

Проверяет, была ли установлена дата создания от которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** bool - True если дата была установлена, false если нет


<a name="method_setCreatedAtGt" class="anchor"></a>
#### public setCreatedAtGt() : self

```php
public setCreatedAtGt(\DateTime|string|null $created_at_gt) : self
```

**Summary**

Устанавливает дату создания от которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">\DateTime OR string OR null</code> | created_at_gt  | Дата создания |

**Returns:** self - 


<a name="method_getCreatedAtLte" class="anchor"></a>
#### public getCreatedAtLte() : null|\DateTime

```php
public getCreatedAtLte() : null|\DateTime
```

**Summary**

Возвращает дату создания до которой будут возвращены платежи или null, если дата не была установлена.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** null|\DateTime - Время создания, до (включительно)


<a name="method_hasCreatedAtLte" class="anchor"></a>
#### public hasCreatedAtLte() : bool

```php
public hasCreatedAtLte() : bool
```

**Summary**

Проверяет, была ли установлена дата создания до которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** bool - True если дата была установлена, false если нет


<a name="method_setCreatedAtLte" class="anchor"></a>
#### public setCreatedAtLte() : self

```php
public setCreatedAtLte(\DateTime|string|null $created_at_lte) : self
```

**Summary**

Устанавливает дату создания до которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">\DateTime OR string OR null</code> | created_at_lte  | Дата |

**Returns:** self - 


<a name="method_getCreatedAtLt" class="anchor"></a>
#### public getCreatedAtLt() : null|\DateTime

```php
public getCreatedAtLt() : null|\DateTime
```

**Summary**

Возвращает дату создания до которой будут возвращены платежи или null, если дата не была установлена.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** null|\DateTime - Время создания, до (не включая)


<a name="method_hasCreatedAtLt" class="anchor"></a>
#### public hasCreatedAtLt() : bool

```php
public hasCreatedAtLt() : bool
```

**Summary**

Проверяет, была ли установлена дата создания до которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** bool - True если дата была установлена, false если нет


<a name="method_setCreatedAtLt" class="anchor"></a>
#### public setCreatedAtLt() : self

```php
public setCreatedAtLt(\DateTime|string|null $created_at_lt) : self
```

**Summary**

Устанавливает дату создания до которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">\DateTime OR string OR null</code> | created_at_lt  | Дата |

**Returns:** self - 


<a name="method_getCapturedAtGte" class="anchor"></a>
#### public getCapturedAtGte() : null|\DateTime

```php
public getCapturedAtGte() : null|\DateTime
```

**Summary**

Возвращает дату создания от которой будут возвращены платежи или null, если дата не была установлена.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** null|\DateTime - Время создания, от (включительно)


<a name="method_hasCapturedAtGte" class="anchor"></a>
#### public hasCapturedAtGte() : bool

```php
public hasCapturedAtGte() : bool
```

**Summary**

Проверяет, была ли установлена дата создания от которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** bool - True если дата была установлена, false если нет


<a name="method_setCapturedAtGte" class="anchor"></a>
#### public setCapturedAtGte() : self

```php
public setCapturedAtGte(\DateTime|string|null $captured_at_gte) : self
```

**Summary**

Устанавливает дату создания от которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">\DateTime OR string OR null</code> | captured_at_gte  | Дата |

**Returns:** self - 


<a name="method_getCapturedAtGt" class="anchor"></a>
#### public getCapturedAtGt() : null|\DateTime

```php
public getCapturedAtGt() : null|\DateTime
```

**Summary**

Возвращает дату создания от которой будут возвращены платежи или null, если дата не была установлена.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** null|\DateTime - Время создания, от (не включая)


<a name="method_hasCapturedAtGt" class="anchor"></a>
#### public hasCapturedAtGt() : bool

```php
public hasCapturedAtGt() : bool
```

**Summary**

Проверяет, была ли установлена дата создания от которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** bool - True если дата была установлена, false если нет


<a name="method_setCapturedAtGt" class="anchor"></a>
#### public setCapturedAtGt() : self

```php
public setCapturedAtGt(\DateTime|string|null $captured_at_gt) : self
```

**Summary**

Устанавливает дату создания от которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">\DateTime OR string OR null</code> | captured_at_gt  | Дата |

**Returns:** self - 


<a name="method_getCapturedAtLte" class="anchor"></a>
#### public getCapturedAtLte() : null|\DateTime

```php
public getCapturedAtLte() : null|\DateTime
```

**Summary**

Возвращает дату создания до которой будут возвращены платежи или null, если дата не была установлена.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** null|\DateTime - Время создания, до (включительно)


<a name="method_hasCapturedAtLte" class="anchor"></a>
#### public hasCapturedAtLte() : bool

```php
public hasCapturedAtLte() : bool
```

**Summary**

Проверяет, была ли установлена дата создания до которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** bool - True если дата была установлена, false если нет


<a name="method_setCapturedAtLte" class="anchor"></a>
#### public setCapturedAtLte() : self

```php
public setCapturedAtLte(\DateTime|string|null $captured_at_lte) : self
```

**Summary**

Устанавливает дату создания до которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">\DateTime OR string OR null</code> | captured_at_lte  | Дата |

**Returns:** self - 


<a name="method_getCapturedAtLt" class="anchor"></a>
#### public getCapturedAtLt() : null|\DateTime

```php
public getCapturedAtLt() : null|\DateTime
```

**Summary**

Возвращает дату создания до которой будут возвращены платежи или null, если дата не была установлена.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** null|\DateTime - Время создания, до (не включая)


<a name="method_hasCapturedAtLt" class="anchor"></a>
#### public hasCapturedAtLt() : bool

```php
public hasCapturedAtLt() : bool
```

**Summary**

Проверяет, была ли установлена дата создания до которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** bool - True если дата была установлена, false если нет


<a name="method_setCapturedAtLt" class="anchor"></a>
#### public setCapturedAtLt() : self

```php
public setCapturedAtLt(\DateTime|string|null $captured_at_lt) : self
```

**Summary**

Устанавливает дату создания до которой выбираются платежи.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">\DateTime OR string OR null</code> | captured_at_lt  | Дата |

**Returns:** self - 


<a name="method_getStatus" class="anchor"></a>
#### public getStatus() : null|string

```php
public getStatus() : null|string
```

**Summary**

Возвращает статус выбираемых платежей или null, если он до этого не был установлен.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** null|string - Статус выбираемых платежей


<a name="method_hasStatus" class="anchor"></a>
#### public hasStatus() : bool

```php
public hasStatus() : bool
```

**Summary**

Проверяет, был ли установлен статус выбираемых платежей.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** bool - True если статус был установлен, false если нет


<a name="method_setStatus" class="anchor"></a>
#### public setStatus() : self

```php
public setStatus(string $status) : self
```

**Summary**

Устанавливает статус выбираемых платежей.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | status  | Статус платежей |

**Returns:** self - 


<a name="method_getPaymentMethod" class="anchor"></a>
#### public getPaymentMethod() : null|string

```php
public getPaymentMethod() : null|string
```

**Summary**

Возвращает код способа оплаты выбираемых платежей или null, если он до этого не был установлен.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** null|string - Код способа оплаты выбираемых платежей


<a name="method_hasPaymentMethod" class="anchor"></a>
#### public hasPaymentMethod() : bool

```php
public hasPaymentMethod() : bool
```

**Summary**

Проверяет, был ли установлен код способа оплаты выбираемых платежей.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

**Returns:** bool - True если код способа оплаты был установлен, false если нет


<a name="method_setPaymentMethod" class="anchor"></a>
#### public setPaymentMethod() : self

```php
public setPaymentMethod(string $payment_method) : self
```

**Summary**

Устанавливает код способа оплаты выбираемых платежей.

**Details:**
* Inherited From: [\YooKassa\Request\Payments\PaymentsRequestInterface](../classes/YooKassa-Request-Payments-PaymentsRequestInterface.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | payment_method  | Код способа оплаты |

**Returns:** self - 




---

### Top Namespaces

* [\YooKassa](../namespaces/yookassa.md)

---

### Reports
* [Errors - 0](../reports/errors.md)
* [Markers - 0](../reports/markers.md)
* [Deprecated - 40](../reports/deprecated.md)

---

This document was automatically generated from source code comments on 2025-09-29 using [phpDocumentor](http://www.phpdoc.org/)

&copy; 2025 YooMoney